/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.item;

import net.jayjay.dangerzone.entity.EntityDynamite;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.item.Item;
import net.jayjay.dangerzone.world.World;

public class ItemDynamite
extends Item {
    private float explosionDamage;

    public ItemDynamite(String tag, int tex, float explosionDamage) {
        super(tag, tex);
        this.explosionDamage = explosionDamage;
    }

    @Override
    public boolean isUseable() {
        return true;
    }

    @Override
    public void onUse(EntityPlayer player) {
        World world = player.world;
        float yaw = (float)Math.toRadians(player.yRot);
        float pitch = (float)Math.toRadians(player.xRot);
        float throwSpeed = 2.0f;
        float dx = (float)(Math.sin(yaw) * Math.cos(pitch)) * throwSpeed;
        float dy = (float)(-Math.sin(pitch)) * throwSpeed;
        float dz = (float)(-Math.cos(yaw) * Math.cos(pitch)) * throwSpeed;
        float spawnOffset = 1.5f;
        float spawnX = player.x + dx * spawnOffset;
        float spawnY = player.y + player.getEyeHeight();
        float spawnZ = player.z + dz * spawnOffset;
        EntityDynamite dynamite = new EntityDynamite(world, spawnX, spawnY, spawnZ, this.explosionDamage, dx, dy, dz);
        player.world.entities.add(dynamite);
    }
}

